<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\Banner;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBannersByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Banner\BannerCMD $params)
 */
class Banner {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取轮播图列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Banner\BannerCMD $bannerCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Banner\BannerDTO[]
     */
    public static function getBanners (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Banner\BannerCMD $bannerCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBanners($bannerCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Banner\BannerDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Banner\Banner');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Banner\Banner');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}