<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain\ProductPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPackageInfoByCityIdByParams(array $params)
 */
class FamilyProductPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取城市下某个套餐的详情信息.family
     *
     * @param  int $cityId 城市id [ require true ]
     * @param  int $packageId 套餐Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\FamilyPackageDTO
     */
    public static function getPackageInfoByCityId (int $cityId, int $packageId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPackageInfoByCityId([
                            "cityId" => $cityId,
                            "packageId" => $packageId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\ProductPackage\FamilyPackageDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'ProductPackage\FamilyProductPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'ProductPackage\FamilyProductPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}