<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCatalogueListByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Catalogue\CatalogueCMD $params)
 */
class Catalogue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取品牌全部产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Catalogue\CatalogueCMD $catalogueCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Catalogue\CatalogueDTO[]
     */
    public static function getCatalogueList (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Catalogue\CatalogueCMD $catalogueCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCatalogueList($catalogueCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Catalogue\CatalogueDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Catalogue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Catalogue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}