<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRecommendClassificationsByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Recommend\RecommendCMD $params)
 */
class Recommend {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取首页分类推荐
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Recommend\RecommendCMD $recommendCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Recommend\RecommendClassificationDTO[]
     */
    public static function getRecommendClassifications (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Recommend\RecommendCMD $recommendCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRecommendClassifications($recommendCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Recommend\RecommendClassificationDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Recommend');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Recommend');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}