<?php
namespace Mainto\Bridge\Invokes\ProjectGuideDomain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPopupsByParams(array|\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Popup\PopupCMD $params)
 */
class Popup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取弹窗列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Popup\PopupCMD $popupCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Popup\PopupDTO[]
     */
    public static function getPopups (\Mainto\Bridge\Structs\ProjectGuideDomain\CMD\Popup\PopupCMD $popupCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPopups($popupCmd),
            "\Mainto\Bridge\Structs\ProjectGuideDomain\DTO\Popup\PopupDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectGuideDomain', 'Popup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectGuideDomain', 'Popup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}