<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPayByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\PayCreateManageCMD $params)
 * @method completePayByParams(array $params)
 */
class PayManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\PayCreateManageCMD $payCreateDto
     * @throws  \Exception
     * @return  array
     */
    public static function createPay (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\PayCreateManageCMD $payCreateDto) {
        return self::getClass()->createPay($payCreateDto);
    }


    /**
     * 完成支付
     *
     * @support  string $orderNo 订单号 [ require true ]
     * @support  string $payType 支付类型，Cash：现金支付 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function completePay () {
        return self::getClass()->completePay([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\PayManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\PayManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}