<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationQueryCmd $params)
 * @method getOccupyResultByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationOccupyCmd $params)
 * @method getOccupyResultForOrderChangeByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationOccupyChangeCmd $params)
 */
class ReservationApi {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationQueryCmd $queryCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationListDTO[]
     */
    public static function getReservationList (\Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationQueryCmd $queryCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReservationList($queryCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationListDTO[]"
        );
    }


    /**
     * 获取占点结果
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationOccupyCmd $occupyCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO
     */
    public static function getOccupyResult (\Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationOccupyCmd $occupyCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOccupyResult($occupyCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO"
        );
    }


    /**
     * 获取订单更改的占点结果
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationOccupyChangeCmd $occupyChangeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO
     */
    public static function getOccupyResultForOrderChange (\Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation\ReservationOccupyChangeCmd $occupyChangeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOccupyResultForOrderChange($occupyChangeCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Api\ReservationApi');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Api\ReservationApi');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}