<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Story;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTagListByParams(array $params)
 * @method getStoryListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryListCMD $params)
 * @method getStoryDetailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryDetailCMD $params)
 * @method updateStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryUpdateCMD $params)
 * @method getStoryInviteByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryInviteCMD $params)
 * @method likeStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryLikeCMD $params)
 * @method likeStoryListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\MyLikeStoryCMD $params)
 * @method getShareOrderByParams(array $params)
 * @method getSharePrepareDetailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryPrepareDetailCMD $params)
 * @method getShareStoryInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryShareInfoCMD $params)
 * @method deleteStoryByParams(array $params)
 * @method createStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryCreateCMD $params)
 * @method batchMatchStoryByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\OrderStoryMatchCMD $params)
 */
class Story {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取标签列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryTagDTO[]
     */
    public static function getTagList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTagList(),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryTagDTO[]"
        );
    }

    /**
     * 获取故事列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryListCMD $storyListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO
     */
    public static function getStoryList (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryListCMD $storyListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoryList($storyListCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO"
        );
    }


    /**
     * 故事详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryDetailCMD $detailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO
     */
    public static function getStoryDetail (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryDetailCMD $detailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoryDetail($detailCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO"
        );
    }


    /**
     * 用户更新故事
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryUpdateCMD $storyCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryUpdateCMD $storyCreateCmd) {
        return self::getClass()->updateStory($storyCreateCmd);
    }


    /**
     * 故事阶段详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryInviteCMD $storyStageCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO
     */
    public static function getStoryInvite (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryInviteCMD $storyStageCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoryInvite($storyStageCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO"
        );
    }


    /**
     * 喜欢|取消喜欢
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryLikeCMD $operateStoryCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function likeStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryLikeCMD $operateStoryCmd) {
        return self::getClass()->likeStory($operateStoryCmd);
    }


    /**
     * 我的喜欢列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\MyLikeStoryCMD $myLikeStoryCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO
     */
    public static function likeStoryList (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\MyLikeStoryCMD $myLikeStoryCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->likeStoryList($myLikeStoryCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO"
        );
    }


    /**
     * 可分享故事的订单
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareOrderDTO
     */
    public static function getShareOrder (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareOrder([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareOrderDTO"
        );
    }

    /**
     * 分享准备详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryPrepareDetailCMD $detailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryPrepareDetailDTO
     */
    public static function getSharePrepareDetail (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryPrepareDetailCMD $detailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSharePrepareDetail($detailCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryPrepareDetailDTO"
        );
    }


    /**
     * 分享链接
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryShareInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareInfoDTO
     */
    public static function getShareStoryInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryShareInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getShareStoryInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareInfoDTO"
        );
    }


    /**
     * 删除故事
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $storyId 故事ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteStory (int $userId, int $storyId) {
        return self::getClass()->deleteStory([
            "userId" => $userId,
            "storyId" => $storyId,
        ]);
    }

    /**
     * 创建故事
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryCreateCMD $storyCreateCmd
     * @throws  \Exception
     * @return  int
     */
    public static function createStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryCreateCMD $storyCreateCmd) {
        return self::getClass()->createStory($storyCreateCmd);
    }


    /**
     * 批量匹配故事
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Story\OrderStoryMatchCMD $storyMatchCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\OrderStoryMatchDTO
     */
    public static function batchMatchStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\OrderStoryMatchCMD $storyMatchCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->batchMatchStory($storyMatchCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\OrderStoryMatchDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Story\Story');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Story\Story');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}