<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderPreferenceByParams(array $params)
 * @method saveOrderPreferenceInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCmd $params)
 * @method saveBatchOrderPreferenceInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceInfoManageCreateCmd $params)
 * @method updateOrderPreferenceInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCmd $params)
 * @method deleteOrderPreferenceInfoByParams(array $params)
 * @method saveOrderPreferenceMoreByParams(array $params)
 */
class OrderPreferenceManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单偏好详情
     *
     * @param  string $orderId 订单Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderPreference (string $orderId) {
        return self::getClass()->getOrderPreference([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 创建订单偏好成员信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCmd $orderPreferenceManageDto
     * @throws  \Exception
     * @return  bool
     */
    public static function saveOrderPreferenceInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCmd $orderPreferenceManageDto) {
        return self::getClass()->saveOrderPreferenceInfo($orderPreferenceManageDto);
    }


    /**
     * 批量创建订单偏好成员信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceInfoManageCreateCmd $orderPreferenceInfoCreateDto
     * @throws  \Exception
     * @return  bool
     */
    public static function saveBatchOrderPreferenceInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceInfoManageCreateCmd $orderPreferenceInfoCreateDto) {
        return self::getClass()->saveBatchOrderPreferenceInfo($orderPreferenceInfoCreateDto);
    }


    /**
     * 编辑订单偏好成员信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCmd $orderPreferenceManageDto
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOrderPreferenceInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCmd $orderPreferenceManageDto) {
        return self::getClass()->updateOrderPreferenceInfo($orderPreferenceManageDto);
    }


    /**
     * 删除订单偏好成员信息
     *
     * @param  int $infoId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteOrderPreferenceInfo (int $infoId) {
        return self::getClass()->deleteOrderPreferenceInfo([
            "infoId" => $infoId,
        ]);
    }

    /**
     * 添加偏好信息更多信息
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $orderId 订单Id [ require true ]
     * @param  string $comment 更多信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveOrderPreferenceMore (int $userId, int $orderId, string $comment) {
        return self::getClass()->saveOrderPreferenceMore([
            "userId" => $userId,
            "orderId" => $orderId,
            "comment" => $comment,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\OrderPreferenceManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\OrderPreferenceManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}