<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\CommonActivity\CommonActivityDetailCmd $params)
 * @method joinByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\CommonActivity\CommonActivityJoinCmd $params)
 */
class CommonActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查看活动信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\CommonActivity\CommonActivityDetailCmd $detailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\CommonActivity\CommonActivityDetailDTO
     */
    public static function detail (\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\CommonActivity\CommonActivityDetailCmd $detailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($detailCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Activity\CommonActivity\CommonActivityDetailDTO"
        );
    }


    /**
     * 参加活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\CommonActivity\CommonActivityJoinCmd $joinCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function join (\Mainto\Bridge\Structs\ProjectFamily\CMD\Activity\CommonActivity\CommonActivityJoinCmd $joinCmd) {
        return self::getClass()->join($joinCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\CommonActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\CommonActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}