<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\OrderCreateCmd $params)
 * @method getOrderGuideByParams(array $params)
 * @method getOrderListByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method getOrderLookPhotoInfoByParams(array $params)
 * @method getOrderPhotoByParams(array $params)
 * @method cancelOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method changeOrderReserveTimeByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\ChangeReserveTimeCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\OrderCreateCmd $orderCreateDto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderCreateDTO
     */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\OrderCreateCmd $orderCreateDto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createOrder($orderCreateDto),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderCreateDTO"
        );
    }


    /**
     * 获取订单支付成功引导
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderGuideDTO
     */
    public static function getOrderGuide (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderGuide([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderGuideDTO"
        );
    }

    /**
     * 获取订单列表
     *
     * @param  string $status 订单状态- total:全部, wait:待拍摄, process:当日拍摄, complete:已完成, close:已关闭 submit:待支付 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderList (string $status = 'total', int $page = 1, int $pageSize = 10) {
        return self::getClass()->getOrderList([
            "status" => $status,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDetail (string $orderNo) {
        return self::getClass()->getOrderDetail([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 获取看片信息
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderLookPhoto\LookPhotoDTO
     */
    public static function getOrderLookPhotoInfo (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderLookPhotoInfo([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderLookPhoto\LookPhotoDTO"
        );
    }

    /**
     * 获取订单照片
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderPhoto\OrderPhotoDTO
     */
    public static function getOrderPhoto (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOrderPhoto([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderPhoto\OrderPhotoDTO"
        );
    }

    /**
     * 取消订单
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelOrder (string $orderNo) {
        return self::getClass()->cancelOrder([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteOrder (string $orderNo) {
        return self::getClass()->deleteOrder([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\ChangeReserveTimeCmd $reserveTimeCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeOrderReserveTime (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\ChangeReserveTimeCmd $reserveTimeCmd) {
        return self::getClass()->changeOrderReserveTime($reserveTimeCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}