<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllCouponsByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\CouponsCmd $params)
 * @method bindPreferentialByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\BindPreferentialCmd $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有的优惠券
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\CouponsCmd $couponsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Preferential\CouponDTO[]
     */
    public static function getAllCoupons (\Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\CouponsCmd $couponsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllCoupons($couponsCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Preferential\CouponDTO[]"
        );
    }


    /**
     * 用户绑定优惠卷
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\BindPreferentialCmd $bindPreferentialCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bindPreferential (\Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\BindPreferentialCmd $bindPreferentialCmd) {
        return self::getClass()->bindPreferential($bindPreferentialCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Preferential\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Preferential\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}