<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductCategoriesByParams(array $params)
 * @method getProductCategoryInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Product\ProductCategoryInfoCmd $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有产品类目
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductCategories (int $storeId) {
        return self::getClass()->getAllProductCategories([
            "storeId" => $storeId,
        ]);
    }

    /**
     * 获取产品类目信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Product\ProductCategoryInfoCmd $productCategoryInfoDto
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCategoryInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Product\ProductCategoryInfoCmd $productCategoryInfoDto) {
        return self::getClass()->getProductCategoryInfo($productCategoryInfoDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}