<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\CardPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\CardPackage\CreateCardPackageCmd $params)
 * @method orderListByParams(array $params)
 * @method detailByParams(array $params)
 * @method infoByParams(array $params)
 */
class CardPackageOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建卡包订单
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\CardPackage\CreateCardPackageCmd $cardPackageCmd
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectFamily\CMD\CardPackage\CreateCardPackageCmd $cardPackageCmd) {
        return self::getClass()->createOrder($cardPackageCmd);
    }


    /**
     * 订阅卡订单列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderListDTO
     */
    public static function orderList (int $userId, int $page = 1, int $pageSize = 20) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderList([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderListDTO"
        );
    }

    /**
     * 订阅卡订单详情
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderDTO
     */
    public static function detail (int $userId, string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "userId" => $userId,
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderDTO"
        );
    }

    /**
     * 订阅卡订单列表
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageInfoDTO
     */
    public static function info (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'CardPackage\CardPackageOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'CardPackage\CardPackageOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}