<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoCmd $params)
 * @method changeUserInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoEditCmd $params)
 * @method feedbackByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\FeedbackCmd $params)
 * @method getProtocolDataByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\GetProtocolCmd $params)
 * @method setProtocolVersionByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\SetProtocolCmd $params)
 * @method getLoginStatusByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoCmd $userInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\UserDetailDTO
     */
    public static function detail (\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoCmd $userInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($userInfoCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\UserDetailDTO"
        );
    }


    /**
     * 更新用户信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoEditCmd $userInfoEditCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeUserInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoEditCmd $userInfoEditCmd) {
        return self::getClass()->changeUserInfo($userInfoEditCmd);
    }


    /**
     * 提交用户反馈
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\FeedbackCmd $feedbackCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function feedback (\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\FeedbackCmd $feedbackCmd) {
        return self::getClass()->feedback($feedbackCmd);
    }


    /**
     * 获取预约协议数据
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\GetProtocolCmd $getProtocolCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\ProtocolVersionDTO
     */
    public static function getProtocolData (\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\GetProtocolCmd $getProtocolCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getProtocolData($getProtocolCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\ProtocolVersionDTO"
        );
    }


    /**
     * 记录预约协议版本
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\SetProtocolCmd $setProtocolCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setProtocolVersion (\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\SetProtocolCmd $setProtocolCmd) {
        return self::getClass()->setProtocolVersion($setProtocolCmd);
    }


    /**
     * 获取用户状态
     *
     * @param  int $userId 用户ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getLoginStatus (int $userId = 0) {
        return self::getClass()->getLoginStatus([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Member\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Member\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}