<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreInfoByParams(array $params)
 * @method getCityStoresByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店信息
     *
     * @param  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Store\DTO\StoreDTO
     */
    public static function getStoreInfo (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreInfo([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Store\DTO\StoreDTO"
        );
    }

    /**
     * 获取城市门店列表
     *
     * @param  int $cityId 城市ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Store\DTO\StoreDTO[]
     */
    public static function getCityStores (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCityStores([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Store\DTO\StoreDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}