<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\VisitQueryCmd $params)
 * @method editNoteByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\EditNoteCmd $params)
 */
class Visit {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\VisitQueryCmd $visitQueryDto
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\VisitListDTO
     */
    public static function getList (\Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\VisitQueryCmd $visitQueryDto) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList($visitQueryDto),
            "\Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\VisitListDTO"
        );
    }


    /**
     * 填写回访情况
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\EditNoteCmd $editNoteCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function editNote (\Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\EditNoteCmd $editNoteCmd) {
        return self::getClass()->editNote($editNoteCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\Visit');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\Visit');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}