<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Invoice;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleCreateCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleUpdateCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleListInterfaceCmd $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method searchCompanyListByParams(array $params)
 * @method searchCompanyInfoByParams(array $params)
 */
class InvoiceTitle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 添加发票抬头
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleCreateCmd $invoiceTitleCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleCreateCmd $invoiceTitleCreateCmd) {
        return self::getClass()->create($invoiceTitleCreateCmd);
    }


    /**
     * 编辑发票抬头
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleUpdateCmd $invoiceTitleUpdateCmd) {
        return self::getClass()->update($invoiceTitleUpdateCmd);
    }


    /**
     * 获取发票抬头列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleListInterfaceCmd $invoiceTitleListInterfaceCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceTitleListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceTitleListInterfaceCmd $invoiceTitleListInterfaceCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($invoiceTitleListInterfaceCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceTitleListDTO"
        );
    }


    /**
     * 删除发票抬头
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $userId, int $invoiceTitleId) {
        return self::getClass()->delete([
            "userId" => $userId,
            "invoiceTitleId" => $invoiceTitleId,
        ]);
    }

    /**
     * 获取发票抬头详情
     *
     * @param  int $invoiceTitleId 发票抬头id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceTitleInfoDTO
     */
    public static function detail (int $invoiceTitleId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "invoiceTitleId" => $invoiceTitleId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceTitleInfoDTO"
        );
    }

    /**
     * 搜索发票抬头列表
     *
     * @param  string $name 发票抬头 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceCompanyDTO[]
     */
    public static function searchCompanyList (string $name) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchCompanyList([
                            "name" => $name,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceCompanyDTO[]"
        );
    }

    /**
     * 搜索发票抬头详情
     *
     * @param  string $code 查询发票抬头返回的code [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceTaxCodeDTO
     */
    public static function searchCompanyInfo (string $code) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchCompanyInfo([
                            "code" => $code,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\Title\InvoiceTaxCodeDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Invoice\InvoiceTitle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Invoice\InvoiceTitle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}