<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Invoice;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvoiceStoresByParams(array $params)
 * @method historyByParams(array $params)
 * @method getInvoiceListByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceListCmd $params)
 * @method createSimpleByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceCreateCmd $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取可开票的门店数据
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $module 模块名:family,himo,mantu [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\InvoiceStoreItemDTO[]
     */
    public static function getInvoiceStores (int $userId, string $module) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInvoiceStores([
                            "userId" => $userId,
                            "module" => $module,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\InvoiceStoreItemDTO[]"
        );
    }

    /**
     * 获取发票历史列表
     *
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @param  string $module 模块名:family,himo,mantu [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\History\InvoiceHistoryListDTO
     */
    public static function history (int $userId, int $page = 1, int $pageSize = 20, string $module) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->history([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                            "module" => $module,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\History\InvoiceHistoryListDTO"
        );
    }

    /**
     * 获取可开票的发票列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceListCmd $invoiceListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\OrderList\InvoiceOrderInfoDTO[]
     */
    public static function getInvoiceList (\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceListCmd $invoiceListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getInvoiceList($invoiceListCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Invoice\DTO\OrderList\InvoiceOrderInfoDTO[]"
        );
    }


    /**
     * 电子发票.开普票
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceCreateCmd $invoiceCreateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createSimple (\Mainto\Bridge\Structs\ProjectFamily\Invoice\Cmd\InvoiceCreateCmd $invoiceCreateCmd) {
        return self::getClass()->createSimple($invoiceCreateCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Invoice\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Invoice\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}