<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\CardPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\CardPackage\Cmd\CardPackageDetailCmd $params)
 */
class CardPackage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订阅卡信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\CardPackage\Cmd\CardPackageDetailCmd $cardPackageDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackage\CardPackageDTO
     */
    public static function detail (\Mainto\Bridge\Structs\ProjectFamily\CardPackage\Cmd\CardPackageDetailCmd $cardPackageDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail($cardPackageDetailCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackage\CardPackageDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'CardPackage\CardPackage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'CardPackage\CardPackage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}