<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\CardPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method orderListByParams(array $params)
 * @method detailByParams(array $params)
 * @method infoByParams(array $params)
 */
class CardPackageOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建卡包订单
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $packageName 卡包名称，four_seasons：四季与你 [ require false ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder () {
        return self::getClass()->createOrder([
        ]);
    }

    /**
     * 订阅卡订单列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageOrderListDTO
     */
    public static function orderList (int $userId, int $page = 1, int $pageSize = 20) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderList([
                            "userId" => $userId,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageOrderListDTO"
        );
    }

    /**
     * 订阅卡订单详情
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageOrderDTO
     */
    public static function detail (int $userId, string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "userId" => $userId,
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageOrderDTO"
        );
    }

    /**
     * 订阅卡订单列表
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageInfoDTO
     */
    public static function info (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'CardPackage\CardPackageOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'CardPackage\CardPackageOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}