<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array $params)
 * @method getOccupyResultByParams(array $params)
 * @method getOccupyResultForOrderChangeByParams(array $params)
 */
class ReservationApi {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取排单表
     *
     * @param  int $storeId 门店编号 [ require true ]
     * @param  string $dateStart 开始日期 [ require true ]
     * @param  string $dateEnd 结束日期 [ require true ]
     * @param  array $productGroup 产品信息 [ require true ]
     * @param  int $orderId 订单编号 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationListDTO[]
     */
    public static function getReservationList (int $storeId, string $dateStart, string $dateEnd, array $productGroup, int $orderId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReservationList([
                            "storeId" => $storeId,
                            "dateStart" => $dateStart,
                            "dateEnd" => $dateEnd,
                            "productGroup" => $productGroup,
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationListDTO[]"
        );
    }

    /**
     * 获取占点结果
     *
     * @param  int $storeId 门店编号 [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  array $productInfo 产品信息 [ require true ]
     * @param  int $orderId 订单编号 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO
     */
    public static function getOccupyResult (int $storeId, string $reserveTime, array $productInfo, int $orderId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOccupyResult([
                            "storeId" => $storeId,
                            "reserveTime" => $reserveTime,
                            "productInfo" => $productInfo,
                            "orderId" => $orderId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO"
        );
    }

    /**
     * 获取订单更改的占点结果
     *
     * @param  array $order 订单信息 [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  int $newStoreId 新的门店编号 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO
     */
    public static function getOccupyResultForOrderChange (array $order, string $reserveTime, int $newStoreId = 0) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getOccupyResultForOrderChange([
                            "order" => $order,
                            "reserveTime" => $reserveTime,
                            "newStoreId" => $newStoreId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Reservation\ApiReservationResultDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Api\ReservationApi');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Api\ReservationApi');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}