<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\CardPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method orderListByParams(array $params)
 * @method detailByParams(array $params)
 */
class CardPackageOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建卡包订单
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $packageName 卡包名称，four_seasons：四季与你 [ require false ]
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder () {
        return self::getClass()->createOrder([
        ]);
    }

    /**
     * 订阅卡订单列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderList (int $page = 1, int $pageSize = 20, int $userId) {
        return self::getClass()->orderList([
            "page" => $page,
            "pageSize" => $pageSize,
            "userId" => $userId,
        ]);
    }

    /**
     * 订阅卡订单详情
     *
     * @param  int $orderId 订阅卡ID [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageOrderDTO
     */
    public static function detail (int $orderId, int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "orderId" => $orderId,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\CardPackage\DTO\CardPackageOrder\CardPackageOrderDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'CardPackage\CardPackageOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'CardPackage\CardPackageOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}