<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPhotoShareCodeByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\PhotoShare\PhotoShareCodeCmd $params)
 * @method getPhotoShareInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\PhotoShare\PhotoShareCodeInfoCmd $params)
 */
class PhotoShareActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取分享秀参数
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\PhotoShare\PhotoShareCodeCmd $photoShareCodeCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Activity\DTO\PhotoShare\PhotoShareCodeDTO
     */
    public static function getPhotoShareCode (\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\PhotoShare\PhotoShareCodeCmd $photoShareCodeCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoShareCode($photoShareCodeCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Activity\DTO\PhotoShare\PhotoShareCodeDTO"
        );
    }


    /**
     * 获取分享秀信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\PhotoShare\PhotoShareCodeInfoCmd $photoShareCodeInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Activity\DTO\PhotoShare\PhotoShareCodeInfoDTO
     */
    public static function getPhotoShareInfo (\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\PhotoShare\PhotoShareCodeInfoCmd $photoShareCodeInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPhotoShareInfo($photoShareCodeInfoCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Activity\DTO\PhotoShare\PhotoShareCodeInfoDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\PhotoShareActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\PhotoShareActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}