<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-14 15:26:36
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Order
 * @method createOrderByParams(array $params) 创建订单
 * @method getOrderGuideByParams(array $params) 获取订单支付成功引导
 * @method getOrderListByParams(array $params) 获取订单列表
 * @method getOrderDetailByParams(array $params) 获取订单详情
 * @method getOrderLookPhotoInfoByParams(array $params) 获取看片信息
 * @method getOrderPhotoByParams(array $params) 获取订单照片
 * @method cancelOrderByParams(array $params) 取消订单
 * @method deleteOrderByParams(array $params) 删除订单
 * @method changeOrderReserveTimeByParams(array $params) 修改预约时间
 */
class Order {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Order\\Order";

    /**
     * 创建订单
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderCreateDTO
    */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\OrderCreateCMD $orderCreateCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrder($orderCreateCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderCreateDTO"
        );
    }

    /**
     * 获取订单支付成功引导
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderGuideDTO
    */
    public static function getOrderGuide (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderGuide(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderGuideDTO"
        );
    }

    /**
     * 获取订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderList (string $status = 'total', int $page = 1, int $pageSize = 10, string $appKey = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderList(["status" => $status, "page" => $page, "pageSize" => $pageSize, "appKey" => $appKey]);
    }

    /**
     * 获取订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getOrderDetail (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderDetail(["orderNo" => $orderNo]);
    }

    /**
     * 获取看片信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderLookPhoto\LookPhotoDTO
    */
    public static function getOrderLookPhotoInfo (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderLookPhotoInfo(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderLookPhoto\LookPhotoDTO"
        );
    }

    /**
     * 获取订单照片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderPhoto\OrderPhotoDTO
    */
    public static function getOrderPhoto (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderPhoto(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderPhoto\OrderPhotoDTO"
        );
    }

    /**
     * 取消订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function cancelOrder (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["orderNo" => $orderNo]);
    }

    /**
     * 删除订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function deleteOrder (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrder(["orderNo" => $orderNo]);
    }

    /**
     * 修改预约时间
     * @return  bool
    */
    public static function changeOrderReserveTime (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\ChangeReserveTimeCMD $changeReserveTimeCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeOrderReserveTime($changeReserveTimeCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}