<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-12 15:59:37
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PhotoAlbum
 * @method getAlbumPhotosByParams(array $params) 获取我的相册
 * @method getPictureTypeByParams(array $params) 获得图片类型
 * @method getPictureMeasureByParams(array $params) 获取照片裁剪尺寸信息
 */
class PhotoAlbum {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Member\\PhotoAlbum";

    /**
     * 获取我的相册
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Member\Album\AlbumDTO
    */
    public static function getAlbumPhotos () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAlbumPhotos([]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Member\Album\AlbumDTO"
        );
    }
    /**
     * 获得图片类型
     * @return  string
    */
    public static function getPictureType (string $orderNum, string $photoVersionId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureType(["orderNum" => $orderNum, "photoVersionId" => $photoVersionId]);
    }
    /**
     * 获取照片裁剪尺寸信息
     * @return  array
    */
    public static function getPictureMeasure () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPictureMeasure();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}