<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchAllProductsByParams(array $params)
 * @method getProductPhotoTemplatesByParams(array $params)
 * @method getProductCitiesByParams(array $params)
 * @method getProductsStoresByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Product\ProductCityDto $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 搜索所有产品
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $keyword 关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchAllProducts (int $storeId, string $keyword) {
        return self::getClass()->searchAllProducts([
            "storeId" => $storeId,
            "keyword" => $keyword,
        ]);
    }

    /**
     * 获取产品照片模板
     *
     * @param  int $productId 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductPhotoTemplates (int $productId) {
        return self::getClass()->getProductPhotoTemplates([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品可拍摄城市
     *
     * @param  mixed $categoryId 产品ID [ require false ]
     * @param  array $packageIds 套餐ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductCities ($categoryId = null, array $packageIds = null) {
        return self::getClass()->getProductCities([
            "categoryId" => $categoryId,
            "packageIds" => $packageIds,
        ]);
    }

    /**
     * 多个 产品组|套餐|子产品|子套餐 门店拍摄情况况列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Product\ProductCityDto $productCityDto
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsStores (\Mainto\Bridge\Structs\ProjectFamily\Objects\Product\ProductCityDto $productCityDto) {
        return self::getClass()->getProductsStores($productCityDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}