<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method registerGeeByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\GetGeeCmd $params)
 * @method validateGeeByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\ValidateGeeCmd $params)
 * @method getSmsCodeByGeeTokenByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\GetSmsCodeByGeeTokenCmd $params)
 */
class Gee {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 极验初始化
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\GetGeeCmd $geeTestCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Member\DTO\GeeTestDTO\RegisterGeeDTO
     */
    public static function registerGee (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\GetGeeCmd $geeTestCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->registerGee($geeTestCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Member\DTO\GeeTestDTO\RegisterGeeDTO"
        );
    }


    /**
     * 极验验证
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\ValidateGeeCmd $validateGeeCmd
     * @throws  \Exception
     * @return  string
     */
    public static function validateGee (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\ValidateGeeCmd $validateGeeCmd) {
        return self::getClass()->validateGee($validateGeeCmd);
    }


    /**
     * 根据极验令牌发送短信验证码
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\GetSmsCodeByGeeTokenCmd $tokenCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function getSmsCodeByGeeToken (\Mainto\Bridge\Structs\ProjectFamily\Member\Cmd\GeeTest\GetSmsCodeByGeeTokenCmd $tokenCmd) {
        return self::getClass()->getSmsCodeByGeeToken($tokenCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Member\Gee');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Member\Gee');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}