<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRefundOrderByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\RefundOrderQueryCmd $params)
 * @method submitRefundByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\SubmitRefundCmd $params)
 * @method getRefundInfoByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\RefundQueryCmd $params)
 * @method modifyRefundAccountByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\SetRefundAccountCmd $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取退款订单信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\RefundOrderQueryCmd $orderQueryCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Order\DTO\Refund\RefundOrderDTO
     */
    public static function getRefundOrder (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\RefundOrderQueryCmd $orderQueryCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundOrder($orderQueryCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Order\DTO\Refund\RefundOrderDTO"
        );
    }


    /**
     * 申请订单退款
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\SubmitRefundCmd $refundCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Order\DTO\Refund\RefundResDTO
     */
    public static function submitRefund (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\SubmitRefundCmd $refundCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->submitRefund($refundCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Order\DTO\Refund\RefundResDTO"
        );
    }


    /**
     * 获取退款信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\RefundQueryCmd $refundQueryCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Order\DTO\Refund\RefundInfoDTO
     */
    public static function getRefundInfo (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\RefundQueryCmd $refundQueryCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundInfo($refundQueryCmd),
            "\Mainto\Bridge\Structs\ProjectFamily\Order\DTO\Refund\RefundInfoDTO"
        );
    }


    /**
     * 修改退款账号
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\SetRefundAccountCmd $accountCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyRefundAccount (\Mainto\Bridge\Structs\ProjectFamily\Order\Cmd\Refund\SetRefundAccountCmd $accountCmd) {
        return self::getClass()->modifyRefundAccount($accountCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Order\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Order\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}