<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchOrdersByParams(array $params)
 * @method createRefundByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\CardPackage\CardPackageOrderRefundCmd $params)
 * @method searchRefundsByParams(array $params)
 * @method getRefundDetailByParams(array $params)
 * @method passRefundByParams(array $params)
 * @method refundRejectByParams(array $params)
 */
class CardPackageOrderRefundManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询订单
     *
     * @param  string $userPhone 手机号 [ require true ]
     * @param  int $page 分页页码 [ require false ]
     * @param  int $pageSize 分页大小 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\CardPackageOrderRefund\OrderSearchDTO
     */
    public static function searchOrders (string $userPhone, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchOrders([
                            "userPhone" => $userPhone,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\CardPackageOrderRefund\OrderSearchDTO"
        );
    }

    /**
     * 创建退款
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\CardPackage\CardPackageOrderRefundCmd $cardPackageOrderRefundManageDto
     * @throws  \Exception
     * @return  bool
     */
    public static function createRefund (\Mainto\Bridge\Structs\ProjectFamily\Manage\Cmd\CardPackage\CardPackageOrderRefundCmd $cardPackageOrderRefundManageDto) {
        return self::getClass()->createRefund($cardPackageOrderRefundManageDto);
    }


    /**
     * 退款列表
     *
     * @support  string $queryType 查询类型，create_time:按创建时间 refund_time:按退款时间 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $status 订单状态 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $userPhone 手机号 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\CardPackageOrderRefund\OrderSearchDTO
     */
    public static function searchRefunds (int $page = 1, int $pageSize = 15) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchRefunds([
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\CardPackageOrderRefund\OrderSearchDTO"
        );
    }

    /**
     * 退款详情
     *
     * @param  int $refundId 退款记录id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\CardPackageOrderRefund\RefundDetailDTO
     */
    public static function getRefundDetail (int $refundId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRefundDetail([
                            "refundId" => $refundId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectFamily\Manage\DTO\CardPackageOrderRefund\RefundDetailDTO"
        );
    }

    /**
     * 通过退款
     *
     * @param  int $refundId 退款记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function passRefund (int $refundId) {
        return self::getClass()->passRefund([
            "refundId" => $refundId,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $refundId 退款记录id [ require true ]
     * @param  string $rejectReason 拒绝原因 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function refundReject (int $refundId, string $rejectReason = '') {
        return self::getClass()->refundReject([
            "refundId" => $refundId,
            "rejectReason" => $rejectReason,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Manage\CardPackageOrderRefundManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Manage\CardPackageOrderRefundManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}