<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Dev;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method clearAllCacheByParams(array $params)
 * @method clearStoreProductsCacheByParams(array $params)
 */
class ClearCache {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 清理全部缓存
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function clearAllCache () {
        return self::getClass()->clearAllCache();
    }

    /**
     * 清理门店产品缓存
     *
     * @support  int $storeId 门店ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearStoreProductsCache () {
        return self::getClass()->clearStoreProductsCache([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Dev\ClearCache');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Dev\ClearCache');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}