<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Question;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSnByParams(array $params)
 * @method createSnByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Objects\Question\SnCreateDto $params)
 */
class Sn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取SN问卷
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  string $orderSign 订单签名 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSn (string $orderNo, string $orderSign) {
        return self::getClass()->getSn([
            "orderNo" => $orderNo,
            "orderSign" => $orderSign,
        ]);
    }

    /**
     * 提交SN问卷
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Objects\Question\SnCreateDto $snCreateDto
     * @throws  \Exception
     * @return  bool
     */
    public static function createSn (\Mainto\Bridge\Structs\ProjectFamily\Objects\Question\SnCreateDto $snCreateDto) {
        return self::getClass()->createSn($snCreateDto);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Question\Sn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Question\Sn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}