<?php
namespace Mainto\Bridge\Invokes\ProjectFamily\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getDetailByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\NewYearDraw\NewYearDrawDetailCmd $params)
 * @method drawByParams(array|\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\NewYearDraw\NewYearDrawSignCmd $params)
 */
class NewYearDrawActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查看新年邀请函
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\NewYearDraw\NewYearDrawDetailCmd $detailCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getDetail (\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\NewYearDraw\NewYearDrawDetailCmd $detailCmd) {
        return self::getClass()->getDetail($detailCmd);
    }


    /**
     * 开启新年邀请函
     *
     * @var  \Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\NewYearDraw\NewYearDrawSignCmd $drawSignCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function draw (\Mainto\Bridge\Structs\ProjectFamily\Activity\Cmd\NewYearDraw\NewYearDrawSignCmd $drawSignCmd) {
        return self::getClass()->draw($drawSignCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectFamily', 'Activity\NewYearDrawActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectFamily', 'Activity\NewYearDrawActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}