<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-10-16 10:00:48
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderMessageHook
 * @method hookOrderSubmitMessageByParams(array $params) 订单提交事件
 * @method hookOrderPaidMessageByParams(array $params) 订单支付完成通知
 * @method hookOrderLookPhotoMessageByParams(array $params) 订单看片通知
 * @method hookOrderLookPhotoCompleteMessageByParams(array $params) 看片完成通知
 * @method hookBigOrderLookPhotoCompleteMessageByParams(array $params) 大单看片完成通知
 * @method hookOrderRetakeSaleByParams(array $params) 重新看片通知
 * @method hookAfterSaleOrderLookPhotoCompleteByParams(array $params) 售后单二次看片完成事件
 */
class OrderMessageHook {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "MessageHook\\OrderMessageHook";

    /**
     * 订单提交事件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookOrderSubmitMessage (string $orderNo, string $fromModule) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookOrderSubmitMessage(["orderNo" => $orderNo, "fromModule" => $fromModule]);
    }

    /**
     * 订单支付完成通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookOrderPaidMessage (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookOrderPaidMessage(["orderId" => $orderId]);
    }

    /**
     * 订单看片通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookOrderLookPhotoMessage (int $orderId, string $type, string $module) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookOrderLookPhotoMessage(["orderId" => $orderId, "type" => $type, "module" => $module]);
    }

    /**
     * 看片完成通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookOrderLookPhotoCompleteMessage (string $orderNum, string $watchType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookOrderLookPhotoCompleteMessage(["orderNum" => $orderNum, "watchType" => $watchType]);
    }

    /**
     * 大单看片完成通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookBigOrderLookPhotoCompleteMessage (string $orderNo, string $module) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookBigOrderLookPhotoCompleteMessage(["orderNo" => $orderNo, "module" => $module]);
    }

    /**
     * 重新看片通知
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookOrderRetakeSale (int $orderId, int $retakeNewOrderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookOrderRetakeSale(["orderId" => $orderId, "retakeNewOrderId" => $retakeNewOrderId]);
    }

    /**
     * 售后单二次看片完成事件
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function hookAfterSaleOrderLookPhotoComplete () {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookAfterSaleOrderLookPhotoComplete([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}