<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-10-16 10:00:07
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderApi
 * @method generatePayLinkByParams(array $params) 生成订单支付链接
 * @method sendPayLinkByParams(array $params) 发送订单支付链接
 */
class OrderApi {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Api\\OrderApi";

    /**
     * 生成订单支付链接
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Order\PayLinkDTO
    */
    public static function generatePayLink (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->generatePayLink(["orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\Order\PayLinkDTO"
        );
    }

    /**
     * 发送订单支付链接
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\Api\DTO\SendMessageResDTO
    */
    public static function sendPayLink (int $orderId, string $orderType, string $phone, string $payUrl) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->sendPayLink(["orderId" => $orderId, "orderType" => $orderType, "phone" => $phone, "payUrl" => $payUrl]),
            "\Mainto\Bridge\Structs\ProjectFamily\Api\DTO\SendMessageResDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}