<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-10-15 09:24:21
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class OrderRefund
 * @method getRefundStatByParams(array $params) 获取订单退款统计
 * @method getRefundOrderByParams(array $params) 获取退款订单信息
 * @method submitRefundByParams(array $params) 申请订单退款
 * @method getRefundInfoByParams(array $params) 获取退款信息
 * @method modifyRefundAccountByParams(array $params) 修改退款账号
 */
class OrderRefund {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Order\\OrderRefund";

    /**
     * 获取订单退款统计
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundStatDTO
    */
    public static function getRefundStat (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Refund\RefundOrderQueryCMD $refundOrderQueryCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundStat($refundOrderQueryCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundStatDTO"
        );
    }

    /**
     * 获取退款订单信息
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundOrderDTO
    */
    public static function getRefundOrder (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Refund\RefundOrderQueryCMD $refundOrderQueryCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundOrder($refundOrderQueryCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundOrderDTO"
        );
    }

    /**
     * 申请订单退款
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundResDTO
    */
    public static function submitRefund (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Refund\SubmitRefundCMD $submitRefundCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->submitRefund($submitRefundCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundResDTO"
        );
    }

    /**
     * 获取退款信息
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundInfoDTO
    */
    public static function getRefundInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Refund\RefundQueryCMD $refundQueryCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundInfo($refundQueryCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Refund\RefundInfoDTO"
        );
    }

    /**
     * 修改退款账号
     * @return  bool
    */
    public static function modifyRefundAccount (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Refund\SetRefundAccountCMD $setRefundAccountCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->modifyRefundAccount($setRefundAccountCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}