<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-10-08 14:18:13
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Coupon
 * @method getAllCouponsByParams(array $params) 获取所有的优惠券
 * @method bindPreferentialByParams(array $params) 用户绑定优惠卷
 * @method bindPreferentialNewByParams(array $params) 用户绑定优惠卷.黄牛治理
 */
class Coupon {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Preferential\\Coupon";

    /**
     * 获取所有的优惠券
     * @return  array
    */
    public static function getAllCoupons (\Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\CouponsCMD $couponsCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllCoupons($couponsCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Preferential\CouponDTO[]"
        );
    }

    /**
     * 用户绑定优惠卷
     * @return  bool
    */
    public static function bindPreferential (\Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\BindPreferentialCMD $bindPreferentialCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindPreferential($bindPreferentialCMD);
    }

    /**
     * 用户绑定优惠卷.黄牛治理
     * @return  string
    */
    public static function bindPreferentialNew (\Mainto\Bridge\Structs\ProjectFamily\CMD\Preferential\BindPreferentialCMD $bindPreferentialCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindPreferentialNew($bindPreferentialCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}