<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-11-05 16:01:05
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CardPackageOrderRefundManage
 * @method searchOrdersByParams(array $params) 查询订单
 * @method createRefundByParams(array $params) 创建退款
 * @method searchRefundsByParams(array $params) 退款列表
 * @method getRefundDetailByParams(array $params) 退款详情
 * @method passRefundByParams(array $params) 通过退款
 * @method refundRejectByParams(array $params) 拒绝退款
 */
class CardPackageOrderRefundManage {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Manage\\CardPackageOrderRefundManage";

    /**
     * 查询订单
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO
    */
    public static function searchOrders (string $userPhone, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchOrders(["userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO"
        );
    }

    /**
     * 创建退款
     * @return  bool
    */
    public static function createRefund (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\CardPackage\CardPackageOrderRefundCMD $cardPackageOrderRefundCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRefund($cardPackageOrderRefundCMD);
    }

    /**
     * 退款列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO
    */
    public static function searchRefunds (int $page = 1, int $pageSize = 15, array $_params = []) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchRefunds(array_merge($_params, ["page" => $page, "pageSize" => $pageSize])),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO"
        );
    }

    /**
     * 退款详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\RefundDetailDTO
    */
    public static function getRefundDetail (int $refundId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundDetail(["refundId" => $refundId]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\RefundDetailDTO"
        );
    }

    /**
     * 通过退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function passRefund (int $refundId, string $refundVoucherNumber) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passRefund(["refundId" => $refundId, "refundVoucherNumber" => $refundVoucherNumber]);
    }

    /**
     * 拒绝退款
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function refundReject (int $refundId, string $rejectReason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundReject(["refundId" => $refundId, "rejectReason" => $rejectReason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}