<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-08-05 13:45:05
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\CardPackage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class CardPackageOrder
 * @method createOrderByParams(array $params) 创建卡包订单
 * @method orderListByParams(array $params) 订阅卡订单列表
 * @method detailByParams(array $params) 订阅卡订单详情
 * @method infoByParams(array $params) 订阅卡订单列表
 */
class CardPackageOrder {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "CardPackage\\CardPackageOrder";

    /**
     * 创建卡包订单
     * @return  array
    */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectFamily\CMD\CardPackage\CreateCardPackageCMD $createCardPackageCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrder($createCardPackageCMD);
    }

    /**
     * 订阅卡订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderListDTO
    */
    public static function orderList (int $userId, int $page = 1, int $pageSize = 20) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderList(["userId" => $userId, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderListDTO"
        );
    }

    /**
     * 订阅卡订单详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderDTO
    */
    public static function detail (int $userId, string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(["userId" => $userId, "orderNo" => $orderNo]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageOrderDTO"
        );
    }

    /**
     * 订阅卡订单列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageInfoDTO
    */
    public static function info (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->info(["userId" => $userId]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\CardPackage\CardPackageOrder\CardPackageInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}