<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-02-27 10:44:23
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Story;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Story
 */
class Story {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Story\\Story";

    /**
     * 获取标签列表
     * @return  array
    */
    public static function getTagList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTagList(),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryTagDTO[]"
        );
    }
    /**
     * 获取故事列表
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO
    */
    public static function getStoryList (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryListCMD $storyListCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoryList($storyListCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO"
        );
    }
    /**
     * 故事详情
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO
    */
    public static function getStoryDetail (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryDetailCMD $storyDetailCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoryDetail($storyDetailCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO"
        );
    }
    /**
     * 用户更新故事
     * @return  bool
    */
    public static function updateStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryUpdateCMD $storyUpdateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStory($storyUpdateCMD);
    }
    /**
     * 故事阶段详情
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO
    */
    public static function getStoryInvite (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryInviteCMD $storyInviteCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoryInvite($storyInviteCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO"
        );
    }
    /**
     * 喜欢|取消喜欢
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryLikeResultDTO
    */
    public static function likeStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryLikeCMD $storyLikeCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->likeStory($storyLikeCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryLikeResultDTO"
        );
    }
    /**
     * 我的喜欢列表
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO
    */
    public static function likeStoryList (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\MyLikeStoryCMD $myLikeStoryCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->likeStoryList($myLikeStoryCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO"
        );
    }
    /**
     * 可分享故事的订单
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareOrderDTO
    */
    public static function getShareOrder (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrder(["userId" => $userId]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareOrderDTO"
        );
    }
    /**
     * 分享准备详情
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryPrepareDetailDTO
    */
    public static function getSharePrepareDetail (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryPrepareDetailCMD $storyPrepareDetailCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSharePrepareDetail($storyPrepareDetailCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryPrepareDetailDTO"
        );
    }
    /**
     * 分享链接
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareInfoDTO
    */
    public static function getShareStoryInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryShareInfoCMD $storyShareInfoCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareStoryInfo($storyShareInfoCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareInfoDTO"
        );
    }
    /**
     * 删除故事
     * @return  bool
    */
    public static function deleteStory (int $userId, int $storyId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStory(["userId" => $userId, "storyId" => $storyId]);
    }
    /**
     * 创建故事
     * @return  int
    */
    public static function createStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryCreateCMD $storyCreateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStory($storyCreateCMD);
    }
    /**
     * 批量匹配故事
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryMatchResDTO
    */
    public static function batchMatchStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\OrderStoryMatchCMD $orderStoryMatchCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchMatchStory($orderStoryMatchCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryMatchResDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}