<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-16 15:58:15
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Product\\Product";

    /**
     * 搜索所有产品
     * @return  array
    */
    public static function searchAllProducts (\Mainto\Bridge\Structs\ProjectFamily\Controllers\Product\CMD\QueryProductCMD $queryProductCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchAllProducts($queryProductCMD);
    }
    /**
     * 获取产品照片模板
     * @return  array
    */
    public static function getProductPhotoTemplates (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductPhotoTemplates(["productId" => $productId]);
    }
    /**
     * 获取产品可拍摄城市
     * @return  array
    */
    public static function getProductCities ( $categoryId = null, array $packageIds = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCities(["categoryId" => $categoryId, "packageIds" => $packageIds]);
    }
    /**
     * 多个 产品组|套餐|子产品|子套餐 门店拍摄情况况列表
     * @return  array
    */
    public static function getProductsAvailableStores (\Mainto\Bridge\Structs\ProjectFamily\CMD\Product\ProductCityCMD $productCityCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProductsAvailableStores($productCityCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Product\Store\ProductStoreDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}