<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-11-28 13:51:38
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CardPackageOrderRefundManage
 */
class CardPackageOrderRefundManage {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Manage\\CardPackageOrderRefundManage";

    /**
     * 查询订单
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO
    */
    public static function searchOrders (string $userPhone, int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchOrders(["userPhone" => $userPhone, "page" => $page, "pageSize" => $pageSize]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO"
        );
    }
    /**
     * 创建退款
     * @return  bool
    */
    public static function createRefund (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\CardPackage\CardPackageOrderRefundCMD $cardPackageOrderRefundCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRefund($cardPackageOrderRefundCMD);
    }
    /**
     * 退款列表
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO
    */
    public static function searchRefunds (int $page = 1, int $pageSize = 15, string $queryType, string $startTime, string $endTime, string $status, string $orderNo, string $userPhone) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->searchRefunds(["page" => $page, "pageSize" => $pageSize, "queryType" => $queryType, "startTime" => $startTime, "endTime" => $endTime, "status" => $status, "orderNo" => $orderNo, "userPhone" => $userPhone]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\OrderSearchDTO"
        );
    }
    /**
     * 退款详情
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\RefundDetailDTO
    */
    public static function getRefundDetail (int $refundId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getRefundDetail(["refundId" => $refundId]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Manage\CardPackageOrderRefund\RefundDetailDTO"
        );
    }
    /**
     * 通过退款
     * @return  bool
    */
    public static function passRefund (int $refundId, string $refundVoucherNumber) {
        return RpcClass::getClass(self::$serviceName, self::$className)->passRefund(["refundId" => $refundId, "refundVoucherNumber" => $refundVoucherNumber]);
    }
    /**
     * 拒绝退款
     * @return  bool
    */
    public static function refundReject (int $refundId, string $rejectReason = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->refundReject(["refundId" => $refundId, "rejectReason" => $rejectReason]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}