<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-02 15:23:15
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class User
 * @method detailByParams(array $params) 获取用户详情
 * @method changeUserInfoByParams(array $params) 更新用户信息
 * @method feedbackByParams(array $params) 提交用户反馈
 * @method getProtocolDataByParams(array $params) 获取预约协议数据
 * @method setProtocolVersionByParams(array $params) 记录预约协议版本
 * @method getLoginStatusByParams(array $params) 获取用户状态
 */
class User {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Member\\User";

    /**
     * 获取用户详情
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\UserDetailDTO
    */
    public static function detail (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoCMD $userInfoCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail($userInfoCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\UserDetailDTO"
        );
    }
    /**
     * 更新用户信息
     * @return  bool
    */
    public static function changeUserInfo (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\UserInfoEditCMD $userInfoEditCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserInfo($userInfoEditCMD);
    }
    /**
     * 提交用户反馈
     * @return  bool
    */
    public static function feedback (\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\FeedbackCMD $feedbackCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->feedback($feedbackCMD);
    }
    /**
     * 获取预约协议数据
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\ProtocolVersionDTO
    */
    public static function getProtocolData (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\GetProtocolCMD $getProtocolCMD = null) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProtocolData($getProtocolCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Member\UserDTO\ProtocolVersionDTO"
        );
    }
    /**
     * 记录预约协议版本
     * @return  bool
    */
    public static function setProtocolVersion (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\User\SetProtocolCMD $setProtocolCMD = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setProtocolVersion($setProtocolCMD);
    }
    /**
     * 获取用户状态
     * @return  bool
    */
    public static function getLoginStatus () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLoginStatus([]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}