<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-02 15:23:15
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class CardPackageOrderManage
 * @method createOrderByParams(array $params) 创建卡包订单
 * @method getOrderListByParams(array $params) 卡包订单列表
 * @method getOrderDetailByParams(array $params) 卡包订单详情
 * @method cancelOrderByParams(array $params) 卡包订单取消
 * @method checkOrderExistByParams(array $params) 检查卡包订单是否存在
 * @method setOrderPaidByParams(array $params) 设置卡包订单支付
 */
class CardPackageOrderManage {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Manage\\CardPackageOrderManage";

    /**
     * 创建卡包订单
     * @return  array
    */
    public static function createOrder (int $packageId, string $linkNo, string $userPhone, string $userName, string $userBirthday) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createOrder(["packageId" => $packageId, "linkNo" => $linkNo, "userPhone" => $userPhone, "userName" => $userName, "userBirthday" => $userBirthday]);
    }
    /**
     * 卡包订单列表
     * @return  array
    */
    public static function getOrderList () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderList([]);
    }
    /**
     * 卡包订单详情
     * @return  array
    */
    public static function getOrderDetail () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderDetail([]);
    }
    /**
     * 卡包订单取消
     * @return  bool
    */
    public static function cancelOrder (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["orderNo" => $orderNo]);
    }
    /**
     * 检查卡包订单是否存在
     * @return  array
    */
    public static function checkOrderExist (string $linkNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkOrderExist(["linkNo" => $linkNo]);
    }
    /**
     * 设置卡包订单支付
     * @return  bool
    */
    public static function setOrderPaid (string $orderNo, string $payType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setOrderPaid(["orderNo" => $orderNo, "payType" => $payType]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}