<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-06-02 09:58:07
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class OrderPreferenceManage
 * @method getOrderPreferenceByParams(array $params) 获取订单偏好详情
 * @method saveOrderPreferenceInfoByParams(array $params) 创建订单偏好成员信息
 * @method saveBatchOrderPreferenceInfoByParams(array $params) 批量创建订单偏好成员信息
 * @method updateOrderPreferenceInfoByParams(array $params) 编辑订单偏好成员信息
 * @method deleteOrderPreferenceInfoByParams(array $params) 删除订单偏好成员信息
 * @method saveOrderPreferenceMoreByParams(array $params) 添加偏好信息更多信息
 */
class OrderPreferenceManage {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Manage\\OrderPreferenceManage";

    /**
     * 获取订单偏好详情
     * @return  array
    */
    public static function getOrderPreference (string $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderPreference(["orderId" => $orderId]);
    }
    /**
     * 创建订单偏好成员信息
     * @return  bool
    */
    public static function saveOrderPreferenceInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCMD $orderPreferenceCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveOrderPreferenceInfo($orderPreferenceCMD);
    }
    /**
     * 批量创建订单偏好成员信息
     * @return  bool
    */
    public static function saveBatchOrderPreferenceInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceInfoManageCreateCMD $orderPreferenceInfoManageCreateCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveBatchOrderPreferenceInfo($orderPreferenceInfoManageCreateCMD);
    }
    /**
     * 编辑订单偏好成员信息
     * @return  bool
    */
    public static function updateOrderPreferenceInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Manage\OrderPreference\OrderPreferenceCMD $orderPreferenceCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOrderPreferenceInfo($orderPreferenceCMD);
    }
    /**
     * 删除订单偏好成员信息
     * @return  bool
    */
    public static function deleteOrderPreferenceInfo (int $infoId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrderPreferenceInfo(["infoId" => $infoId]);
    }
    /**
     * 添加偏好信息更多信息
     * @return  bool
    */
    public static function saveOrderPreferenceMore (int $userId, int $orderId, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveOrderPreferenceMore(["userId" => $userId, "orderId" => $orderId, "comment" => $comment]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}