<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-08-22 11:48:01
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Pay
 */
class Pay {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Order\\Pay";

    /**
     * 创建支付
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentResDTO
    */
    public static function createPay (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PayCreateCMD $payCreateCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createPay($payCreateCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentResDTO"
        );
    }
    /**
     * 关闭支付
     * @return  bool
    */
    public static function closePay (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closePay(["orderNo" => $orderNo]);
    }
    /**
     * 零元支付
     * @return  bool
    */
    public static function zeroPay (string $orderNo) {
        return RpcClass::getClass(self::$serviceName, self::$className)->zeroPay(["orderNo" => $orderNo]);
    }
    /**
     * 获取支付签名
     * @return  \Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentSignDTO
    */
    public static function paySign (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\PaySignCMD $paySignCMD) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->paySign($paySignCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Pay\PaymentSignDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}