<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-19 16:36:19
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Cart
 */
class Cart {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Member\\Cart";

    /**
     * 加入商品到购物车
     * @return  bool
    */
    public static function add (\Mainto\Bridge\Structs\ProjectFamily\CMD\Member\Cart\CartAddCMD $cartAddCMD) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add($cartAddCMD);
    }
    /**
     * 购物车信息
     * @return  array
    */
    public static function info (int $cityId, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->info(["cityId" => $cityId, "storeId" => $storeId]);
    }
    /**
     * 将商品从购物车中移出
     * @return  bool
    */
    public static function remove (array $cartIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["cartIds" => $cartIds]);
    }
    /**
     * 获取购物车商品数量
     * @return  int
    */
    public static function count (int $cityId, int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->count(["cityId" => $cityId, "storeId" => $storeId]);
    }
    /**
     * 获取产品类目的套餐购物车信息
     * @return  array
    */
    public static function getPackageCartInfo (int $cityId, int $storeId,  $categoryId = null,  $packageId = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageCartInfo(["cityId" => $cityId, "storeId" => $storeId, "categoryId" => $categoryId, "packageId" => $packageId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}