<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-28 19:00:25
 */
namespace Mainto\Bridge\Structs\ProjectFamily\Api\Cmd\Reservation;

class ReservationQueryCmd {
    /**
     * @var  int
     * 门店ID
     * validation: 
     */
    public int $storeId;
    /**
     * @var  string
     * 开始时间
     * validation: date_format:Y-m-d
     */
    public string $dateStart;
    /**
     * @var  string
     * 结束时间
     * validation: date_format:Y-m-d
     */
    public string $dateEnd;
    /**
     * @var  array
     * 产品信息
     * validation: 
     */
    public array $productGroup;
    /**
     * @var  int
     * 订单ID
     * validation: 
     */
    public int $orderId = 0;
    /**
     * @var  bool
     * 重新计算占点
     * validation: 
     */
    public bool $calcOccupyNum = true;

    public function __construct (int $storeId = 0, string $dateStart = '', string $dateEnd = '', array $productGroup = []) {
        $this->storeId = $storeId;
        $this->dateStart = $dateStart;
        $this->dateEnd = $dateEnd;
        $this->productGroup = $productGroup;
    }

    public static function create(int $storeId = 0, string $dateStart = '', string $dateEnd = '', array $productGroup = []): self {
        return new self($storeId, $dateStart, $dateEnd, $productGroup);
    }

    public function setStoreId(int $storeId): self {
        $this->storeId = $storeId;

        return $this;
    }

    public function setDateStart(string $dateStart): self {
        $this->dateStart = $dateStart;

        return $this;
    }

    public function setDateEnd(string $dateEnd): self {
        $this->dateEnd = $dateEnd;

        return $this;
    }

    public function setProductGroup(array $productGroup): self {
        $this->productGroup = $productGroup;

        return $this;
    }

    public function setOrderId(int $orderId): self {
        $this->orderId = $orderId;

        return $this;
    }

    public function setCalcOccupyNum(bool $calcOccupyNum): self {
        $this->calcOccupyNum = $calcOccupyNum;

        return $this;
    }
}