<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-09 14:02:20
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Story;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Story
 */
class Story {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Story\\Story";

    /**
     * 获取标签列表
     */
    public static function getTagList (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getTagList(),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryTagDTO[]"
        );
    }
    /**
     * 获取故事列表
     */
    public static function getStoryList (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryListCMD $storyListCMD = null): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoryList($storyListCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO"
        );
    }
    /**
     * 故事详情
     */
    public static function getStoryDetail (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryDetailCMD $storyDetailCMD): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoryDetail($storyDetailCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO"
        );
    }
    /**
     * 用户更新故事
     */
    public static function updateStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryUpdateCMD $storyUpdateCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStory($storyUpdateCMD);
    }
    /**
     * 故事阶段详情
     */
    public static function getStoryInvite (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryInviteCMD $storyInviteCMD): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoryInvite($storyInviteCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryDetailDTO"
        );
    }
    /**
     * 喜欢|取消喜欢
     */
    public static function likeStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryLikeCMD $storyLikeCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->likeStory($storyLikeCMD);
    }
    /**
     * 我的喜欢列表
     */
    public static function likeStoryList (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\MyLikeStoryCMD $myLikeStoryCMD = null): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->likeStoryList($myLikeStoryCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryListDTO"
        );
    }
    /**
     * 可分享故事的订单
     */
    public static function getShareOrder (int $userId): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareOrder(["userId" => $userId, ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareOrderDTO"
        );
    }
    /**
     * 分享准备详情
     */
    public static function getSharePrepareDetail (?\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryPrepareDetailCMD $storyPrepareDetailCMD = null): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryPrepareDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getSharePrepareDetail($storyPrepareDetailCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryPrepareDetailDTO"
        );
    }
    /**
     * 分享链接
     */
    public static function getShareStoryInfo (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryShareInfoCMD $storyShareInfoCMD): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getShareStoryInfo($storyShareInfoCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\ShareInfoDTO"
        );
    }
    /**
     * 删除故事
     */
    public static function deleteStory (int $userId, int $storyId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteStory(["userId" => $userId, "storyId" => $storyId, ]);
    }
    /**
     * 创建故事
     */
    public static function createStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\StoryCreateCMD $storyCreateCMD): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->createStory($storyCreateCMD);
    }
    /**
     * 批量匹配故事
     */
    public static function batchMatchStory (\Mainto\Bridge\Structs\ProjectFamily\CMD\Story\OrderStoryMatchCMD $orderStoryMatchCMD): \Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryMatchResDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchMatchStory($orderStoryMatchCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Story\StoryMatchResDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}