<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-14 16:20:58
 */
namespace Mainto\Bridge\Invokes\ProjectFamily\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "ProjectFamily";

    private static string $className = "Order\\Order";

    /**
     * 创建订单
     */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\OrderCreateCMD $orderCreateCMD): \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderCreateDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrder($orderCreateCMD),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderCreateDTO"
        );
    }
    /**
     * 获取订单支付成功引导
     */
    public static function getOrderGuide (string $orderNo): \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderGuideDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderGuide(["orderNo" => $orderNo, ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\Order\OrderGuideDTO"
        );
    }
    /**
     * 获取订单列表
     */
    public static function getOrderList (string $status = 'total', int $page = 1, int $pageSize = 10): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderList(["status" => $status, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 获取订单详情
     */
    public static function getOrderDetail (string $orderNo): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderDetail(["orderNo" => $orderNo, ]);
    }
    /**
     * 获取看片信息
     */
    public static function getOrderLookPhotoInfo (string $orderNo): \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderLookPhoto\LookPhotoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderLookPhotoInfo(["orderNo" => $orderNo, ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderLookPhoto\LookPhotoDTO"
        );
    }
    /**
     * 获取订单照片
     */
    public static function getOrderPhoto (string $orderNo): \Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderPhoto\OrderPhotoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderPhoto(["orderNo" => $orderNo, ]),
            "\Mainto\Bridge\Structs\ProjectFamily\DTO\Order\OrderPhoto\OrderPhotoDTO"
        );
    }
    /**
     * 取消订单
     */
    public static function cancelOrder (string $orderNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder(["orderNo" => $orderNo, ]);
    }
    /**
     * 删除订单
     */
    public static function deleteOrder (string $orderNo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrder(["orderNo" => $orderNo, ]);
    }
    /**
     * 修改预约时间
     */
    public static function changeOrderReserveTime (\Mainto\Bridge\Structs\ProjectFamily\CMD\Order\Order\ChangeReserveTimeCMD $changeReserveTimeCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeOrderReserveTime($changeReserveTimeCMD);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}